<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

// Página actual
$page = $_GET['page'] ?? 'home';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sorteos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f9;
        }
        header {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        header h1 {
            margin: 0;
            font-size: 1.5rem;
        }
        header a {
            color: white;
            text-decoration: none;
            background-color: #0056b3;
            padding: 5px 10px;
            border-radius: 5px;
        }
        header a:hover {
            background-color: #003f8a;
        }
        nav {
            background-color: #343a40;
            padding: 10px;
            display: flex;
            justify-content: center;
        }
        nav a {
            color: white;
            text-decoration: none;
            margin: 0 15px;
            padding: 10px;
            border-radius: 5px;
        }
        nav a:hover {
            background-color: #495057;
        }
        main {
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: auto;
        }
        h2 {
            color: #333;
        }
    </style>
</head>
<body>
    <header>
        <h1>Dashboard - Bienvenido <?= $_SESSION['user'] ?></h1>
        <a href="logout.php">Cerrar Sesión</a>
    </header>
    <nav>
        <a href="dashboard.php?page=home">Inicio</a>
        <a href="dashboard.php?page=upload">Subir Base de Datos</a>
        <a href="dashboard.php?page=manage_sorteos">Gestión de Sorteos</a>
        <a href="dashboard.php?page=sorteo">Realizar Sorteo</a>
        <a href="dashboard.php?page=logs">Ver Logs</a>
    </nav>
    <main>
        <div class="container">
            <?php
            if ($page === 'upload') {
                include 'upload.php';
            } elseif ($page === 'manage_sorteos') {
                include 'manage_sorteos.php';
            } elseif ($page === 'sorteo') {
                include 'sorteo.php';
            } elseif ($page === 'logs') {
                include 'logs.php';
            } else {
                echo "<h2>Inicio</h2><p>Bienvenido al sistema de gestión de sorteos. Utiliza el menú de arriba para navegar.</p>";
            }
            ?>
        </div>
    </main>
</body>
</html>
