<?php
require_once 'vendor/autoload.php'; // PhpWord autoload

use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\IOFactory;

session_start();

// Validar sesión de usuario
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

// Archivo de sorteos aprobados
$sorteosFile = __DIR__ . '/logs/sorteos.log';
$sorteos = json_decode(file_get_contents($sorteosFile), true) ?? [];

// Buscar el sorteo aprobado más reciente
$approvedSorteo = null;
foreach ($sorteos as $sorteo) {
    if ($sorteo['status'] === 'aprobado') {
        $approvedSorteo = $sorteo;
        break;
    }
}

if (!$approvedSorteo) {
    die("No hay sorteos aprobados disponibles.");
}

// Crear el archivo Word con PhpWord
$phpWord = new PhpWord();

$section = $phpWord->addSection();
$section->addTitle("Resultados del Sorteo", 1);
$section->addText("Descripción: " . $approvedSorteo['description'], ['bold' => true]);
$section->addText("Fecha: " . date("Y-m-d"), ['bold' => true]);
$section->addTextBreak(2);

// Lista de ganadores
if (!empty($approvedSorteo['winners'])) {
    $table = $section->addTable();
    $table->addRow();
    $table->addCell(3000)->addText("Nombre del Ganador", ['bold' => true]);
    $table->addCell(3000)->addText("Tabla Ganadora", ['bold' => true]);

    foreach ($approvedSorteo['winners'] as $winner) {
        $table->addRow();
        $table->addCell(3000)->addText($winner['nombre_completo']);
        $table->addCell(3000)->addText($winner['tabla']);
    }
} else {
    $section->addText("No hay ganadores registrados.", ['italic' => true]);
}

// Guardar el archivo
$outputFile = __DIR__ . '/uploads/Resultados_Sorteo_' . date('Ymd_His') . '.docx';
$phpWord->save($outputFile, 'Word2007');

// Descargar el archivo generado
header('Content-Description: File Transfer');
header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
header('Content-Disposition: attachment; filename="' . basename($outputFile) . '"');
header('Content-Transfer-Encoding: binary');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($outputFile));
readfile($outputFile);
exit();
?>
