<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

// Leer logs
$logFile = __DIR__ . '/logs/system.log';
$logs = [];
if (file_exists($logFile)) {
    $logs = file($logFile, FILE_IGNORE_NEW_LINES);
}
?>
<h2>Logs del Sistema</h2>
<table border="1">
    <tr>
        <th>Fecha</th>
        <th>Usuario</th>
        <th>Acción</th>
    </tr>
    <?php foreach ($logs as $log): ?>
        <?php list($date, $user, $action) = explode('|', $log); ?>
        <tr>
            <td><?= $date ?></td>
            <td><?= $user ?></td>
            <td><?= $action ?></td>
        </tr>
    <?php endforeach; ?>
</table>
