<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

// Archivo de sorteos
$sorteosFile = __DIR__ . '/logs/sorteos.log';
$sorteos = [];

// Leer sorteos desde el archivo si existe
if (file_exists($sorteosFile)) {
    $sorteos = json_decode(file_get_contents($sorteosFile), true) ?? [];
}

// Manejar aprobación o rechazo de sorteos
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $id = $_POST['id'] ?? '';

    foreach ($sorteos as &$sorteo) {
        if ($sorteo['id'] === $id) {
            if ($action === 'approve') {
                $sorteo['status'] = 'aprobado';
            } elseif ($action === 'reject') {
                $sorteo['status'] = 'rechazado';
            }
            break;
        }
    }

    file_put_contents($sorteosFile, json_encode($sorteos));
    header('Location: dashboard.php?page=manage_sorteos');
    exit();
}
?>
<h2>Gestión de Sorteos</h2>
<table border="1">
    <tr>
        <th>ID</th>
        <th>Descripción</th>
        <th>Estado</th>
        <th>Acciones</th>
    </tr>
    <?php foreach ($sorteos as $sorteo): ?>
        <tr>
            <td><?= $sorteo['id'] ?></td>
            <td><?= $sorteo['description'] ?></td>
            <td><?= $sorteo['status'] ?></td>
            <td>
                <?php if ($sorteo['status'] === 'pendiente'): ?>
                    <form method="post" style="display: inline-block;">
                        <input type="hidden" name="id" value="<?= $sorteo['id'] ?>">
                        <button type="submit" name="action" value="approve">Aprobar</button>
                    </form>
                    <form method="post" style="display: inline-block;">
                        <input type="hidden" name="id" value="<?= $sorteo['id'] ?>">
                        <button type="submit" name="action" value="reject">Rechazar</button>
                    </form>
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach; ?>
</table>
