<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

// Ruta al archivo CSV
$filePath = __DIR__ . '/uploads/participantes.csv';
$participants = [];

// Cargar participantes
if (file_exists($filePath)) {
    $file = fopen($filePath, 'r');
    $header = fgetcsv($file, 1000, ';'); // Leer encabezados
    while (($row = fgetcsv($file, 1000, ';')) !== false) {
        $participants[] = [
            'nombre_completo' => $row[0],
            'tabla' => $row[1]
        ];
    }
    fclose($file);
}

// Manejar el sorteo
$winner = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($participants)) {
    $randomIndex = array_rand($participants);
    $winner = $participants[$randomIndex];

    // Eliminar al ganador de la lista
    unset($participants[$randomIndex]);

    // Guardar los participantes restantes
    $file = fopen($filePath, 'w');
    fputcsv($file, $header);
    foreach ($participants as $participant) {
        fputcsv($file, $participant);
    }
    fclose($file);
}
?>
<h2>Realizar Sorteo</h2>
<?php if ($winner): ?>
    <p style="color: green;">¡Ganador seleccionado!</p>
    <p><strong>Nombre:</strong> <?= $winner['nombre_completo'] ?></p>
    <p><strong>Tabla:</strong> <?= $winner['tabla'] ?></p>
<?php endif; ?>
<form method="post">
    <button type="submit" <?= empty($participants) ? 'disabled' : '' ?>>Seleccionar Ganador</button>
</form>
<p><?= empty($participants) ? 'No hay más participantes disponibles.' : '' ?></p>
