<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

// Ruta para guardar los archivos subidos y el registro de archivos
$uploadDir = __DIR__ . '/uploads/';
$logFile = __DIR__ . '/logs/uploaded_files.json';
$message = '';

// Leer el registro de archivos existentes
$uploadedFiles = [];
if (file_exists($logFile)) {
    $uploadedFiles = json_decode(file_get_contents($logFile), true);
}

// Manejar la subida del archivo
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $filename = basename($_FILES['file']['name']);
    $filePath = $uploadDir . $filename;

    if (move_uploaded_file($_FILES['file']['tmp_name'], $filePath)) {
        $uploadedFiles[] = [
            'filename' => $filename,
            'uploaded_at' => date('Y-m-d H:i:s'),
            'used' => false
        ];
        file_put_contents($logFile, json_encode($uploadedFiles, JSON_PRETTY_PRINT));
        $message = "Archivo subido correctamente.";
    } else {
        $message = "Error al subir el archivo.";
    }
}

// Manejar la eliminación de archivos
if (isset($_POST['delete'])) {
    $deleteFilename = $_POST['delete'];
    $fileFound = false; // Bandera para verificar si se encuentra el archivo

    foreach ($uploadedFiles as $index => $file) {
        if ($file['filename'] === $deleteFilename && !$file['used']) {
            $fileFound = true;
            $fullPath = $uploadDir . $deleteFilename;
            if (file_exists($fullPath)) {
                unlink($fullPath); // Eliminar archivo físico
            }
            unset($uploadedFiles[$index]); // Eliminar del registro
            file_put_contents($logFile, json_encode(array_values($uploadedFiles), JSON_PRETTY_PRINT));
            $message = "Archivo eliminado correctamente.";
            break;
        }
    }

    if (!$fileFound) {
        $message = "El archivo no fue encontrado o ya fue utilizado.";
    }
}
?>
<h2>Subir Base de Datos</h2>
<?php if ($message): ?>
    <p style="color: green;"><?= $message ?></p>
<?php endif; ?>
<form method="post" enctype="multipart/form-data">
    <label for="file">Seleccione el archivo CSV:</label>
    <input type="file" name="file" id="file" required><br><br>
    <button type="submit">Subir</button>
</form>

<h2>Archivos Subidos</h2>
<table border="1">
    <tr>
        <th>Nombre del Archivo</th>
        <th>Fecha de Subida</th>
        <th>Estado</th>
        <th>Acciones</th>
    </tr>
    <?php foreach ($uploadedFiles as $file): ?>
        <tr>
            <td><?= $file['filename'] ?></td>
            <td><?= $file['uploaded_at'] ?></td>
            <td><?= $file['used'] ? 'Usado' : 'No Usado' ?></td>
            <td>
                <?php if (!$file['used']): ?>
                    <form method="post" style="display:inline;">
                        <input type="hidden" name="delete" value="<?= $file['filename'] ?>">
                        <button type="submit">Eliminar</button>
                    </form>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach; ?>
</table>
